const app = getApp();
Page({
  data: {
    userInfo:{},
    dev_no:"",
    start_time:"请选择开始时间",
    end_time:"请选择结束时间",
    list:{}
  },
  onLoad: function (options) {
    this.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
    this.getList();
  },
  getList(){
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "get_fail_scan_device_list",
        dev_no: PageThis.data.dev_no,
        start_time: PageThis.data.start_time == "请选择开始时间" ? "" : PageThis.data.start_time,
        end_time: PageThis.data.end_time == "请选择结束时间" ? "" : PageThis.data.end_time,
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success(res){
        var ret = res.data;
        if(Number(ret.state) === 1){
          PageThis.setData({
            list:ret.data
          })
        }
      }
    })
  },
  //**页面跳转 */
  navigateTo: function (e) {
    var _url = e.currentTarget.dataset.url;
    var _id = e.currentTarget.dataset.id;
    wx.navigateTo({
      url: _url + "?id=" + _id,
    })
  },
  inputChange:function(e){
    var PageThis = this;
    PageThis.setData({
      "pay_no": e.detail.value
    })
  },  pickerChange:function(e){
    var PageThis = this;
    var name = e.currentTarget.dataset.name;
    var val = e.detail.value;
    switch(name){
      case "start_time":
        PageThis.setData({
          start_time: val
        })
        break;
      case "end_time":
        PageThis.setData({
          end_time: val
        })
        break;
    }
  },
  reset:function(){
    var PageThis = this;
    PageThis.setData({
      dev_no: "",
      start_time: "请选择开始时间",
      end_time: "请选择结束时间",
    })
  }
})