const app = getApp();
Page({
  data: {
    tabIndex:0,
    tabList:[],
    tab_swiper_index:0,
    list:[]
  },
  onLoad: function (options) {
    var id = options.id;
    var item = ["失败记录","成功记录"];
    var list = [];
    for(var i in item){
      var obj = {
        "tabName":item[i],
        "tabClass":"",
        "tabIndex":i,
        "tabContent":[]
      }
      list.push(obj);
    }
    list[0]['tabClass'] = "tab_item_active";
    this.setData({
      userInfo:wx.getStorageSync('userInfo'),
      tabList:list
    })
    this.getData(id);
  },
  onTabItem(e){
    var PageThis = this;
    var index = e.currentTarget.dataset.page;
    var tabList = PageThis.data.tabList;
    for(var i in tabList){
      if(Number(tabList[i].tabIndex) === Number(index)){
        tabList[i].tabClass = "tab_item_active";
      }else{
        tabList[i].tabClass = "";
      }
    }
    PageThis.setData({
      tabIndex:index,
      tabList:tabList
    })
  },
  tabSwiperChange(e){
    var PageThis = this;
    var index = e.detail.current;
    var tabList = PageThis.data.tabList;
    for(var i in tabList){
      if(Number(tabList[i].tabIndex) === Number(index)){
        tabList[i].tabClass = "tab_item_active";
      }else{
        tabList[i].tabClass = "";
      }
    }
    PageThis.setData({
      tab_swiper_index:index,
      tabList:tabList
    })
  },
  fakeData(){
    var PageThis = this;
    var data = [];
    var title = {
      "brand":"手机品牌",
      "model":"手机型号",
      "system":"操作系统",
      "edition":"软件版本",
      "type":"手机类型",
      "state":"连接状态",
      "ip":"IP地址",
      "time":"连接时间"
    }
    data.push(title);
    for(var i=0;i<50;i++){
      var obj = {
        "brand":"apple",
        "model":"iphone11",
        "system":"14.0.2",
        "edition":"7.0.16",
        "type":"ios",
        "state":"wx-蓝牙连接失败",
        "ip":"42.90.71.108",
        "time":"2020-07-20 02:45:07"
      }
      data.push(obj);
    }
    PageThis.setData({
      list:data
    })
  },
  getData(id){
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "get_one_device_scan_list",
        dev_id: id,
        login_manager_id: PageThis.data.userInfo.manager_id,
      },
      success:function(res){
        var ret = res.data;
        var data = [];
        var title = {
          "scan_mobile_brand":"手机品牌",
          "scan_mobile_model":"手机型号",
          "scan_mobile_os":"操作系统",
          "scan_mobile_version":"软件版本",
          "scan_mobile_type":"手机类型",
          "scan_result":"连接状态",
          "scan_ip":"IP地址",
          "scan_time":"连接时间",
          "scan_result":99
        }
        data.push(title);
        for(var i in ret.data){
          data.push(ret.data[i]);
        }
        PageThis.setData({
          "list":data
        })
      }
    })
  }
})