// pages/bluetoothWarningOrders/index.js
const app = getApp();
Page({
  data: {
    ordersList:[],
    userInfo:{}
  },
  onLoad: function (options) {
    var id = options.id;
    this.setData({
      userInfo:wx.getStorageSync('userInfo'),
    })
    this.getData(id);
  },
  getData(id){
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "get_one_device_orders_detail",
        dev_id: id,
        login_manager_id: PageThis.data.userInfo.manager_id,
      },
      success:function(res){
        console.log(res);
        PageThis.setData({
          ordersList:res.data.data
        })
      }
    })
  }
})