// pages/cardDetail/index.js
const app = getApp();
Page({
  data: {
    userInfo: wx.getStorageSync('userInfo'),
    cardId:0,
    cardInfo: {}
  },
  onLoad: function (options){
    var PageThis = this;
    PageThis.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
    var id = options.id;
    this.setData({
      cardId: id
    })
  },
  onShow: function (options) {
    this.getCardDetail();
  },
  //**页面跳转 */
  navigateTo: function (e) {
    var _url = e.currentTarget.dataset.url;
    var _id = e.currentTarget.dataset.id;
    wx.navigateTo({
      url: _url + "?id=" + _id,
    })
  },
  getCardDetail:function(){
    var PageThis = this;
    var id = PageThis.data.cardId;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "get_bank_card_detail",
        card_id: id,
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success: function (res) {
        var data = res.data.data;
        PageThis.setData({
          "cardInfo": data
        })
      }
    })
  }
})