// pages/createCared/index.js
const app = getApp();
Page({
  data: {
    userInfo: wx.getStorageSync('userInfo'),
    cardInfo: {}
  },
  onLoad(){
    var PageThis = this;
    PageThis.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
  },
  createCard:function(){
    var PageThis = this;
    var cardInfo = PageThis.data.cardInfo;
    cardInfo['api_name'] = "add_bank_card";
    cardInfo['login_manager_id'] = PageThis.data.userInfo.manager_id
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: cardInfo,
      success:function(res){
        res = res.data;
        if(res.state == 1){
          wx.showToast({
            title: '创建成功',
            icon: 'success',
            duration: 1500,
          })
          setTimeout(function(){
            wx.navigateBack()
          },1500);
        }else{
          wx.showToast({
            title: res.msg,
            icon: 'none',
            duration: 2000,
          })
        }
      }
    })
  },
  inputChange: function (e) {
    var PageThis = this;
    var name = e.currentTarget.dataset.name;
    var data = PageThis.data.cardInfo;
    data[name] = e.detail.value;
    PageThis.setData({
      "cardInfo": data
    })
  },
})