// pages/createHotel/index.js
const app = getApp();
Page({
  data: {
    userInfo: wx.getStorageSync('userInfo'),
    hotelInfo: {},
    hotel_type_name:"请选择酒店类型",
    hotel_type_list:[],
    hotel_type_value:[],
    plan_title:"请选择商品方案",
    plan_list: [],
    plan_list_value:[],
    introduce_list:[],
    rep_list:[],
    user_list:[],
    area_list:[],
    area_val:0,
    introduce_val:0,
    user_val:0,
    rep_val:0
  },
  onLoad: function (options) {
    var PageThis = this;
    PageThis.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
    this.getHotelType();
    this.getPlanList();
    this.getHotelManager();
    this.getArea();
  },
  getHotelType:function(){
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "hotel_type",
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success:function(res){
        var data = res.data.data;
        var hotel_type_list = [];
        for (var i in data) {
          hotel_type_list.push(data[i].t_title);
        }
        PageThis.setData({
          "hotel_type_value": data,
          "hotel_type_list": hotel_type_list
        })
      }
    })
  },
  getPlanList: function () {
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "goods_plan",
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success: function (ret) {
        var data = ret.data.data;
        var plan_list = [];
        for (var i in data){
          plan_list.push(data[i].gp_title);
        }
        PageThis.setData({
          "plan_list_value": data,
          "plan_list": plan_list
        })
      }
    })
  },
  changeInput:function(e){
    var PageThis = this;
    var name = e.currentTarget.dataset.name;
    var data = PageThis.data.hotelInfo;
    data[name] = e.detail.value;
    PageThis.setData({
      "hotelInfo": data
    })
  },
  changePicker:function(e){
    var PageThis = this;
    var name = e.currentTarget.dataset.name;
    var data = PageThis.data.hotelInfo;
    var value = e.detail.value;
    switch (name){
      case "h_type_id":
        var typeId = PageThis.data.hotel_type_value[value].t_id;
        data['h_type_id'] = typeId;
        PageThis.setData({
          "hotel_type_name": PageThis.data.hotel_type_value[value].t_title,
          "hotelInfo": data
        })
        break;
      case "h_default_goods_plan":
        var planId = PageThis.data.plan_list_value[value].gp_id;
        data['h_default_goods_plan'] = planId;
        PageThis.setData({
          "plan_title": PageThis.data.plan_list_value[value].gp_title,
          "hotelInfo": data
        })
        break;
      case "h_introduce_id":
        var introduce_list = PageThis.data.introduce_list;
        data['h_introduce_id'] = introduce_list[value].manager_id;
        PageThis.setData({
          "hotelInfo": data,
          "introduce_val":value
        })
        break;
      case "h_rep_id":
        var rep_list = PageThis.data.rep_list;
        data['h_rep_id'] = rep_list[value].manager_id;
        PageThis.setData({
          "hotelInfo": data,
          "rep_val":value
        })
        break;
      case "h_user_id":
        var user_list = PageThis.data.user_list;
        data['h_user_id'] = user_list[value].manager_id;
        PageThis.setData({
          "hotelInfo": data,
          "user_val":value
        })
        break;
      case "h_lot_id":
        var area_list = PageThis.data.area_list;
        data['h_lot_id'] = area_list[value].lot_id;
        PageThis.setData({
          "hotelInfo": data,
          "area_val":value
        })
        break;
    }
  },
  /**
   * 获取酒店管理人员
   */
  getHotelManager(){
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "get_hotel_manager",
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success: function (ret) {
        var data = ret.data.data;
        data['introduce'].unshift({
          "manager_id":0,
          "manager_nickname":"请选择介绍人"
        });
        data['manager_hotel'].unshift({
          "manager_id":0,
          "manager_nickname":"请选择酒店管理员"
        });
        data['rep'].unshift({
          "manager_id":0,
          "manager_nickname":"请选择补货员"
        });
        PageThis.setData({
          introduce_list: data['introduce'],
          user_list: data['manager_hotel'],
          rep_list: data['rep'],
        })
      }
    })
  },
  /**
   * 获取位置地段
   */
  getArea(){
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data:{
        api_name: "get_hotel_lot",
      },
      success:function(res){
        var ret = res.data;
        if(Number(ret.state) === 1){
          var obj = {
            lot_id:0,
            lot_title:"请选择位置地段"
          }
          ret.data.unshift(obj);
          PageThis.setData({
            "area_list": ret.data
          })
        }
      }
    })
  },
  /**
   * 创建酒店
   */
  createHotel:function(){
    var PageThis = this;
    var hotelInfo = PageThis.data.hotelInfo;
    hotelInfo['api_name'] = "create_hotel";
    hotelInfo['login_manager_id'] = PageThis.data.userInfo.manager_id;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: hotelInfo,
      success:function(res){
        res = res.data;
        if (Number(res.state) == 1) {
          wx.showToast({
            title: '创建成功',
            icon: 'success',
            duration: 2000,
            success: function () {
              wx.navigateBack({
                url: '../hotelList/index',
              })
            }
          })
        } else {
          wx.showToast({
            title: res.msg,
            icon: 'none',
            duration: 2000
          })
        }
      }
    })
  }
})