// pages/daySheet/index.js
const app = getApp();
Page({
  data: {
    userInfo:{},
    pageData:{}
  },
  onLoad: function (options) {
    this.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
  },
  onShow: function () {
    this.getData();
  },
  getData: function () {
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "get_day_sheet",
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success: function (res) {
        console.log(res);
        PageThis.setData({
          pageData:res.data.data
        })
      }
    })
  },
})