// pages/deviceDetail/index.js
const app = getApp();
Page({
  /**
   * 页面的初始数据
   */
  data: {
    userInfo: wx.getStorageSync('userInfo'),
    deviceDetail:{},
    deviceId: 0
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    var PageThis = this;
    PageThis.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
    var id = options.id;
    this.setData({
      "deviceId":id
    })
    this.getDeviceDetail();
  },
  //**页面跳转 */
  navigateTo: function (e) {
    var _url = e.currentTarget.dataset.url;
    var _id = e.currentTarget.dataset.id;
    wx.navigateTo({
      url: _url + "?id=" + _id,
    })
  },
  /**获取设备 */
  getDeviceDetail:function(){
    var PageThis = this;
    var id = PageThis.data.deviceId;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data:{
        api_name: "device_detail",
        device_id:id,
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success:function(res){
        for(var i in res.data.data){
          if (i != "dev_no_stock_lattice" && (res.data.data[i] == null || res.data.data[i] == "")){
            res.data.data[i] = "--";
          }
        }
        PageThis.setData({
          "deviceDetail": res.data.data
        })
      }
    })
  },
  unbindDevice(){
    var PageThis = this;
    wx.showModal({
      title: '温馨提示',
      content: '确定要解绑该设备？解绑后将会抹除所有绑定信息',
      success:function(res){
        if (res.confirm){
          wx.request({
            url: app.globalData.serverInfo.gateWayUrl,
            header: {
              'content-type': 'application/json'
            },
            method: 'POST',
            data:{
              api_name: "unbind_device",
              dev_no:PageThis.data.deviceDetail.dev_no,
              login_manager_id: PageThis.data.userInfo.manager_id
            },
            success:function(res){
              wx.showToast({
                title: '解绑成功',
              })
              PageThis.getDeviceDetail();
            }
          })
        }
      }
    })
  }
})