// pages/goodsList/index.js
const app = getApp();
Page({
  data: {
    userInfo: wx.getStorageSync('userInfo'),
    searchTitle:"",
    goodsList:[]
  },
  onLoad: function (options) {
    var PageThis = this;
    PageThis.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
    this.getGoodsList();
  },
  //**页面跳转 */
  navigateTo: function (e) {
    var _url = e.currentTarget.dataset.url;
    var _id = e.currentTarget.dataset.id;
    wx.navigateTo({
      url: _url + "?id=" + _id,
    })
  },
  /**获取商品列表 */
  getGoodsList:function(){
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data:{
        api_name: "goods_list",
        search_title: PageThis.data.searchTitle,
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success:function(res){
        var data = res.data.data;
        console.log(data);
        PageThis.setData({
          "goodsList": data
        });
      }
    })
  },
  /**搜索监听 */
  changeSearch:function(e){
    var PageThis = this;
    var title = e.detail.value;
    PageThis.setData({
      "searchTitle": title
    });
  }
})