// pages/goodsPlanDetail/index.js
const app = getApp();
Page({
  data: {
    userInfo: wx.getStorageSync('userInfo'),
    planDetail:{},
    planId: 0
  },
  onLoad: function (options) {
    var id = options.id;
    var PageThis = this;
    PageThis.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
    this.setData({
      "planId": id
    })
  },
  onShow: function () {
    this.getGoodsPlanDetail();
  },
  //**页面跳转 */
  navigateTo: function (e) {
    var _url = e.currentTarget.dataset.url;
    var _id = e.currentTarget.dataset.id;
    wx.navigateTo({
      url: _url + "?id=" + _id,
    })
  },
  getGoodsPlanDetail:function(){
    var PageThis = this;
    var id = PageThis.data.planId;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "goods_plan_detail",
        gp_id: id,
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success:function(res){
        console.log(res);
        var data = res.data.data
        console.log(data);
        PageThis.setData({
          "planDetail":data
        })
      }
    })
  }
})