// pages/goodsSalesStatistics/index.js
const app = getApp();
Page({
  data: {
    userInfo: wx.getStorageSync('userInfo'),
    start_time:"请选择开始时间",
    end_time: "请选择结束时间",
    total_orders_goods: 0,
    total_orders_money: 0,
    goodsList:[],
    hotelValue: [], //酒店列表数组
    hotelIndex:0, //酒店列表数组picker选中【键值】
    hotelId: 0,//存储的酒店ID
    radioList:[
      {
        "name":"否",
        "value":1,
        "checked":true
      },
      {
        "name":"是",
        "value":2,
        "checked":false
      }
    ]
  },
  getHotelList: function () {
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "hotel_list_value",
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success: function (res) {
        var data = res.data.data;
        PageThis.setData({
          "hotelValue": data
        })
      }
    })
  },
  onLoad: function (options) {
    var PageThis = this;
    PageThis.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
    this.getData();
    this.getHotelList();
  },
  getData:function(){
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "goods_data_count",
        start_time: PageThis.data.start_time == "请选择开始时间" ? "" : PageThis.data.start_time,
        end_time: PageThis.data.end_time == "请选择结束时间" ? "" : PageThis.data.end_time,
        login_manager_id: PageThis.data.userInfo.manager_id,
        hotel_id: PageThis.data.hotelId
      },
      success:function(res){
        var res = res.data;
        if(res.state == 1){
          PageThis.setData({
            "total_orders_money": res.data.total_orders_money,
            "total_orders_goods": res.data.total_orders_goods,
            "goodsList": res.data.goods_list
          })
        }else{
          PageThis.setData({
            "total_orders_money": 0,
            "total_orders_goods": 0,
            "goodsList": []
          })
        }
      }
    })
  },
  pickerChange: function (e) {
    var PageThis = this;
    var val = e.detail.value;
    var name = e.target.dataset.name;
    switch (name) {
      case "start_time":
        PageThis.setData({
          start_time: val
        })
        break;
      case "end_time":
        PageThis.setData({
          end_time: val
        })
        break;
      case "hotel":
        //hotelIndex存储picker选中【键值】
        //hotelId存储picker选中【h_id】
        PageThis.setData({
          hotelIndex: e.detail.value,
          hotelId: this.data.hotelValue[e.detail.value].h_id
        })
        break;
    }
  },
  radioChange(e){
    var PageThis = this;
    var goodsInfo = PageThis.data.goodsInfo;
    goodsInfo['g_money_type'] = e.detail.value;
    PageThis.setData({
      "goodsInfo":goodsInfo
    })
  }
})