// pages/handleMessage/index.js
const app = getApp()

Page({
  data: {
    userInfo:{},
    tabList:[],
    tab_swiper_index:0,
    list:[]
  },
  onLoad: function (options) {
    var item = ["用户反馈","银行卡审核","提现审核","退款审核"];
    var list = [];
    for(var i in item){
      var obj = {
        "tabName":item[i],
        "tabClass":"",
        "tabIndex":i,
        "tabContent":[]
      }
      list.push(obj);
    }
    list[0]['tabClass'] = "tab_item_active";
    this.setData({
      userInfo:wx.getStorageSync('userInfo'),
      tabList:list
    });
  },
  onShow(){
    this.getToDoList();
  },
  onTabItem(e){
    var PageThis = this;
    var index = e.currentTarget.dataset.page;
    var tabList = PageThis.data.tabList;
    for(var i in tabList){
      if(Number(tabList[i].tabIndex) === Number(index)){
        tabList[i].tabClass = "tab_item_active";
      }else{
        tabList[i].tabClass = "";
      }
    }
    PageThis.setData({
      tab_swiper_index:index,
      tabList:tabList
    })
  },
  tabSwiperChange(e){
    var PageThis = this;
    var index = e.detail.current;
    var tabList = PageThis.data.tabList;
    for(var i in tabList){
      if(Number(tabList[i].tabIndex) === Number(index)){
        tabList[i].tabClass = "tab_item_active";
      }else{
        tabList[i].tabClass = "";
      }
    }
    PageThis.setData({
      tab_swiper_index:index,
      tabList:tabList
    })
  },
  getToDoList(){
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "get_to_do_list",
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success:function(res){
        var data = res.data.data;
        app.globalData.handleNum = data.total_number;
        PageThis.setData({
          list:data
        })
      }
    })
  },
  handleMessage(e){
    var PageThis = this;
    var name = e.currentTarget.dataset.name;
    var type = e.currentTarget.dataset.type;
    var id = e.currentTarget.dataset.id;
    var str = "";
    var obj = {};
    obj.api_name = name;
    obj.login_manager_id = PageThis.data.userInfo.manager_id;
    if(name == "reply_user_feedback"){
      str = "确认已处理该反馈？";
      obj.feedback_id = id;
    }else if(name == "auth_bank_card"){
      if(Number(type) == 2){
        str = "确认通过该银行卡申请？";
      }else if(Number(type) == 3){
        str = "确认驳回该银行卡申请？";
      }
      obj.card_id = id;
      obj.state = type;
    }else if(name == "auth_apply_withdraw"){
      if(Number(type) == 2){
        str = "确认通过该提现申请？";
      }else if(Number(type) == 4){
        str = "确认驳回该提现申请？";
      }
      obj.w_id = id;
      obj.state = type;
      obj.target = app.globalData.ThisWechatTarget;
      obj.type = app.globalData.ThisWechatType;
    }else if(name == "auth_refund_orders"){
      if(Number(type) == 1){
        str = "确认通过该退款申请？";
      }else if(Number(type) == 2){
        str = "确认驳回该退款申请？";
      }
      obj.pay_id = id;
      obj.result = type;
    }else{
      wx.showToast({
        title: '未知类型',
        icon: "none"
      })
      return;
    }
    wx.showModal({
      title: '温馨提示',
      content: str,
      success(r){
        if(r.confirm){
          wx.request({
            url: app.globalData.serverInfo.gateWayUrl,
            header: {
              'content-type': 'application/json'
            },
            method: 'POST',
            data: obj,
            success(res){
              var ret = res.data;
              if(Number(ret.state) === 1){
                wx.showToast({
                  title: ret.msg,
                })
                PageThis.getToDoList();
              }else{
                wx.showToast({
                  title: ret.msg,
                  icon: 'none'
                })
              }
            }
          })
        }
      }
    })
  }
})