// pages/login/index.js
const app = getApp();
Page({
  data: {
    login_name:"",
    login_password:"",
    switchChecked: true,
  },
  onLoad(){
    var PageThis = this;
    PageThis.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
    if(wx.getStorageSync('username')!=''){
      PageThis.setData({
        login_name:wx.getStorageSync('username')
      })
    };
    if(wx.getStorageSync('password')!=''){
      PageThis.setData({
        login_password:wx.getStorageSync('password')
      })
    };
  },
  clickRegister:function(){
    wx.navigateTo({
      url: '../register/index',
    })
  },
  switchChange:function(e){
    this.setData({
      switchChecked:e.detail.value
    });
  },
  formSubmit:function(e){
    var PageThis = this;
    wx.showLoading({
      title: '登录中...',
    });
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "login",
        username: e.detail.value.login_name,
        password: e.detail.value.login_password,
      },
      success: function (res) {
        wx.hideLoading();
        if(res.data.state == 1){
          wx.showToast({
            title: '登录成功',
            icon: 'success',
            duration: 500,
            success:function(){
              wx.setStorage({
                key: 'userInfo',
                data: res.data.data
              })
              wx.setStorage({
                key: 'username',
                data: e.detail.value.login_name
              })
              wx.setStorage({
                key: 'password',
                data: e.detail.value.login_password
              })
              wx.switchTab({
                url: '../index/index',
              })
            }
          })
        }else{
          wx.showToast({
            title: res.data.msg,
            icon: 'none',
            duration: 500
          })
        }
      },fail:function(err){
        wx.showToast({
          title: "网络异常",
          icon: 'none',
          duration: 500
        })
      }
    })
  }
})