// pages/ordersSalesStatistics/index.js
const app = getApp();
Page({
  data: {
    userInfo: {},
    start_time:"请选择开始时间",
    end_time:"请选择结束时间",
    timeType:"day",
    userName:"",
    pageData:{
      total_device_num:0,
      total_hotel_num:0,
      total_orders_num:0,
      total_sep_money:0,
      date_list:[]
    }
  },
  onLoad: function (options) {
    var item = ["按日","按月"];
    var list = [];
    for(var i in item){
      var obj = {
        "tabName":item[i],
        "tabClass":"",
        "tabIndex":i,
        "tabContent":[]
      }
      list.push(obj);
    }
    list[0]['tabClass'] = "tab_item_active";
    this.setData({
      userInfo:wx.getStorageSync('userInfo'),
      tabList:list
    });
  },
  onShow: function () {
    this.getData();
  },
  onTabItem(e){
    var PageThis = this;
    var index = e.currentTarget.dataset.page;
    var tabList = PageThis.data.tabList;
    for(var i in tabList){
      if(Number(tabList[i].tabIndex) === Number(index)){
        tabList[i].tabClass = "tab_item_active";
      }else{
        tabList[i].tabClass = "";
      }
    }
    var timeType;
    if(Number(index) == 0){
      timeType = "day";
    }else{
      timeType = "month";
    }
    PageThis.setData({
      tab_swiper_index:index,
      tabList:tabList,
      timeType:timeType
    })
    PageThis.reset();
    PageThis.getData();
  },
  pickerChange: function (e) {
    var PageThis = this;
    var val = e.detail.value;
    var name = e.target.dataset.name;
    switch (name) {
      case "start_time":
        PageThis.setData({
          start_time: val,
        })
        break;
      case "end_time":
        PageThis.setData({
          end_time: val,
        })
        break;
    }
  },
  inputChange:function(e){
    var PageThis = this;
    PageThis.setData({
      "userName": e.detail.value
    })
  },
  getData(){
    var PageThis = this;
    wx.request({
      url:app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "get_date_orders_count",
        login_manager_id: PageThis.data.userInfo.manager_id,
        username:PageThis.data.userName,
        start_time: PageThis.data.start_time == "请选择开始时间" ? "" : PageThis.data.start_time,
        end_time: PageThis.data.end_time == "请选择结束时间" ? "" : PageThis.data.end_time,
        count_type:PageThis.data.timeType == "day" ? 1 : 2
      },
      success:function(res){
        var data = res.data.data;
        console.log(data.date_list)
        PageThis.setData({
          pageData:data
        })
      }
    })
  },
  reset:function(){
    var PageThis = this;
    PageThis.setData({
      userName: "",
      start_time: "请选择开始时间",
      end_time: "请选择结束时间",
    })
  }
})