// pages/refundList/index.js
const app = getApp();
Page({
  data: {
    userInfo: wx.getStorageSync('userInfo'),
    payNo:"",
    hotelName:"",
    start_time:"请选择开始时间",
    end_time:"请选择结束时间",
    list:[]
  },
  onLoad: function (options) {
    this.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
  },
  onShow: function () {
    this.getList();
  },
  pickerChange:function(e){
    var PageThis = this;
    var name = e.currentTarget.dataset.name;
    var val = e.detail.value;
    switch(name){
      case "start_time":
        PageThis.setData({
          start_time: val
        })
        break;
      case "end_time":
        PageThis.setData({
          end_time: val
        })
        break;
    }
  },
  inputChange:function(e){
    var PageThis = this;
    var name = e.currentTarget.dataset.name;
    switch(name){
      case "pay_no":
        PageThis.setData({
          "payNo": e.detail.value
        })
        break;
      case "hotel_name":
        PageThis.setData({
          "hotelName": e.detail.value
        })
        break;
    }
  },
  reset:function(){
    var PageThis = this;
    PageThis.setData({
      payNo: "",
      hotelName: "",
      start_time: "请选择开始时间",
      end_time: "请选择结束时间",
    })
  },
  getList(){
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "get_refund_list",
        orders_no: PageThis.data.payNo,
        hotel_title: PageThis.data.hotelName,
        login_manager_id: PageThis.data.userInfo.manager_id,
        start_time: PageThis.data.start_time == "请选择开始时间" ? "" : PageThis.data.start_time,
        end_time: PageThis.data.end_time == "请选择结束时间" ? "" : PageThis.data.end_time,
      },
      success: function (res) {
        var data = res.data.data;
        PageThis.setData({
          list:data
        })
      }
    })
  },
  handleMessage(e){
    var PageThis = this;
    var name = e.currentTarget.dataset.name;
    var type = e.currentTarget.dataset.type;
    var id = e.currentTarget.dataset.id;
    var str = "";
    var obj = {};
    obj.api_name = name;
    obj.login_manager_id = PageThis.data.userInfo.manager_id;
    if(name == "auth_refund_orders"){
      if(Number(type) == 1){
        str = "确认通过该退款申请？";
      }else if(Number(type) == 2){
        str = "确认驳回该退款申请？";
      }
      obj.pay_id = id;
      obj.result = type;
    }else{
      wx.showToast({
        title: '未知类型',
        icon: "none"
      })
      return;
    }
    wx.showModal({
      title: '温馨提示',
      content: str,
      success(r){
        if(r.confirm){
          wx.request({
            url: app.globalData.serverInfo.gateWayUrl,
            header: {
              'content-type': 'application/json'
            },
            method: 'POST',
            data: obj,
            success(res){
              var ret = res.data;
              if(Number(ret.state) === 1){
                wx.showToast({
                  title: ret.msg,
                })
                PageThis.getList();
              }else{
                wx.showToast({
                  title: ret.msg,
                  icon: 'none'
                })
              }
            }
          })
        }
      }
    })
  }
})