const app = getApp();
Page({
  data: {
    userInfo: wx.getStorageSync('userInfo'),
    dev_no: "",
    hotelList: [],
    hotelValue: [],
    hotelName: "请选择酒店",
    hotel_id: "",
    partnerList: [],
    partnerValue: [],
    partnerName: "请选择补货员",
    partner_id: "",
    start_time: "请选择开始时间",
    end_time: "请选择结束时间",
    recordList: []
  },
  onLoad: function (options) {
    var PageThis = this;
    PageThis.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
  },
  onShow: function(){
    this.getRepList();
    this.getHotelList();
    this.getPartnerList();
  },
  getRepList:function(){
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "get_rep_list",
        dev_no: PageThis.data.dev_no,
        hotel_id: PageThis.data.hotel_id,
        rep_manager_id: PageThis.data.partner_id,
        start_time: PageThis.data.start_time == "请选择开始时间" ? "" : PageThis.data.start_time,
        end_time: PageThis.data.end_time == "请选择结束时间" ? "" : PageThis.data.end_time,
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success:function(res){
        var data = res.data.data;
        PageThis.setData({
          "recordList": data
        })
      }
    })
  },
  getHotelList: function () {
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "hotel_list",
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success: function (res) {
        var data = res.data.data;
        var hotelList = [];
        for (var i in data) {
          hotelList.push(data[i].h_title)
        }
        hotelList.push("全部");
        PageThis.setData({
          "hotelList": hotelList,
          "hotelValue": data
        })
      }
    })
  },
  getPartnerList: function () {
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "manager_list",
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success: function (res) {
        var data = res.data.data;
        var managerList = [];
        var managerValue = [];
        for (var i in data) {
          if (data[i].manager_type == 7) {
            managerList.push(data[i]['manager_username']);
            managerValue.push(data[i])
          }
        }
        managerList.push("全部");
        PageThis.setData({
          "partnerList": managerList,
          "partnerValue": managerValue
        })
      }
    })
  },
  pickerChange: function (e) {
    var PageThis = this;
    var name = e.currentTarget.dataset.name;
    var val = e.detail.value;
    switch (name) {
      case "hotel":
        var hotelList = PageThis.data.hotelList;
        var hotelValue = PageThis.data.hotelValue;
        if (hotelValue == hotelList.length) {
          PageThis.setData({
            "hotelName": "请选择酒店",
            "hotelId": 0
          })
        } else {
          PageThis.setData({
            "hotelName": hotelList[val],
            "hotelId": hotelValue[val]['h_id']
          })
        }
        break;
      case "partner":
        var partnerList = PageThis.data.partnerList;
        var partnerValue = PageThis.data.partnerValue;
        if (partnerValue == partnerList.length) {
          PageThis.setData({
            "partnerName": "请选择补货员",
            "partnerId": 0
          })
        } else {
          PageThis.setData({
            "partnerName": partnerList[val],
            "partnerId": partnerValue[val]['h_id']
          })
        }
        break;
      case "start_time":
        PageThis.setData({
          start_time: val
        })
        break;
      case "end_time":
        PageThis.setData({
          end_time: val
        })
        break;
    }
  },
  inputChange: function (e) {
    var PageThis = this;
    PageThis.setData({
      "dev_no": e.detail.value
    })
  },
  reset: function () {
    var PageThis = this;
    PageThis.setData({
      dev_no: "",
      hotelName: "请选择酒店",
      hotel_id: 0,
      partnerName: "请选择补货员",
      partner_id: 0,
      start_time: "请选择开始时间",
      end_time: "请选择结束时间",
    })
  }
})