// pages/separateDetail/index.js
const app = getApp();
Page({
  data: {
    userInfo: wx.getStorageSync('userInfo'),
    payId: 0,
    info:{},
    list:[]
  },
  onLoad: function (option) {
    var id = option.id;
    var PageThis = this;
    PageThis.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
    this.setData({
      "payId":id
    })
  },
  onShow: function () {
    this.getDetail();
  },
  getDetail:function(){
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "get_orders_separate",
        pay_id: PageThis.data.payId,
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success:function(res){
        console.log(res.data.data);
        PageThis.setData({
          "info": res.data.data[0],
          "list": res.data.data
        })
      }
    })
  },
  refundOrders:function(){
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "auth_refund_orders",
        result: 1,
        pay_id: PageThis.data.payId,
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success:function(res){
        wx.showToast({
          title: res.data.msg,
          icon:'none'
        })
        setTimeout(function () {
          wx.switchTab({
            url: '../index/index',
          })
        }, 1500);
      }
    })
  }
})