// pages/updateUser/index.js
const app = getApp();
Page({

  /**
   * 页面的初始数据
   */
  data: {
    userInfo:{},
    managerInfo:{},
    manager_type_name:"合伙人",
    manager_type_list:["合伙人","运维人员","介绍人","酒店管理员","补货员"],
    manager_type:[
      {
        type_title:"合伙人",
        type_id:3
      },
      {
        type_title:"运维人员",
        type_id:4
      },
      {
        type_title:"介绍人",
        type_id:5
      },
      {
        type_title:"酒店管理员",
        type_id:6
      },
      {
        type_title:"补货员",
        type_id:7
      },
    ],
    managerId:0,
    password:""
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    var id = options.id;
    this.setData({
      userInfo:wx.getStorageSync('userInfo'),
      "managerId": id
    })
  },
  onShow(){
    this.getManagerInfo();
  },
  changeInput:function(e){
    var PageThis = this;
    var name = e.currentTarget.dataset.name;
    var data = PageThis.data.managerInfo;
    data[name] = e.detail.value;
    PageThis.setData({
      "managerInfo": data
    })
    console.log(name);
    console.log(data);
    console.log(data[name]);
    console.log(PageThis.data);
  },
  changePicker:function(e){
    var PageThis = this;
    var data = PageThis.data.managerInfo;
    var value = e.detail.value;
    var type_id = PageThis.data.manager_type[value].type_id;
    data['manager_type'] = type_id;
    PageThis.setData({
      "manager_type_name": PageThis.data.manager_type[value].type_title,
      "managerInfo": data
    })
  },
  changePasswordInput:function(e){
    var PageThis = this;
    PageThis.setData({
      "password": e.detail.value
    })
  },
  //获取用户信息
  getManagerInfo(){
    var PageThis = this;
    var id = PageThis.data.managerId;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "get_manager_info",
        manager_id: id,
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success:function(res){
        var data = res.data.data;     
        var manager_type_name = "";
        switch(Number(data.manager_type)){
          case 1:
            manager_type_name = "平台";
            break;
          case 2:
            manager_type_name = "生产厂商";
            break;
          case 3:
            manager_type_name = "合伙人";
            break;
          case 4:
            manager_type_name = "运维人员";
            break;
          case 5:
            manager_type_name = "介绍人";
            break;
          case 6:
            manager_type_name = "酒店管理员";
            break;
          case 7:
            manager_type_name = "补货员";
            break;
        }
        console.log(manager_type_name);
        PageThis.setData({
          "managerInfo": data,
          "manager_type_name":manager_type_name
        })
      }
    })
  },
  updateManager:function(){
    var PageThis = this;
    var managerInfo = PageThis.data.managerInfo;
    managerInfo['api_name'] = "update_manager";
    managerInfo['login_manager_id'] = PageThis.data.userInfo.manager_id;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        "api_name":'update_manager',
        "login_manager_id":PageThis.data.userInfo.manager_id,
        "manager_id":PageThis.data.managerInfo.manager_id,
        "manager_type":PageThis.data.managerInfo.manager_type,
        "manager_nickname":PageThis.data.managerInfo.manager_nickname,
        "manager_username":PageThis.data.managerInfo.manager_username,
        "manager_percent":PageThis.data.managerInfo.manager_percent,
        "manager_fee":PageThis.data.managerInfo.manager_fee,
        "manager_pid":PageThis.data.managerInfo.manager_pid,
        "manager_password":PageThis.data.password,
      },
      success:function(res){
        res = res.data;
        console.log(res);
        if (Number(res.state) == 1) {
          wx.showToast({
            title: res.msg,
            icon: 'none',
            duration: 2000,
            success: function () {
              wx.navigateTo({
                url: '../userList/index',
              })
            }
          })
        } else {
          wx.showToast({
            title: res.msg,
            icon: 'none',
            duration: 2000
          })
        }
      }
    })
  }
})