const app = getApp();
Page({
  data: {
    userInfo: {},
    userName:"",
    pageData:[]
  },
  onLoad: function (options) {
    this.setData({
      userInfo:wx.getStorageSync('userInfo'),
    });
  },
  onShow: function () {
    this.getData();
  },
  inputChange:function(e){
    var PageThis = this;
    PageThis.setData({
      "userName": e.detail.value
    })
  },
  getData(){
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "get_user_data_count",
        login_manager_id: PageThis.data.userInfo.manager_id,
        username:PageThis.data.userName,
      },
      success:function(res){
        var data = res.data.data;
        PageThis.setData({
          pageData:data
        })
      }
    })
  }
})