// pages/withdrawal/index.js
var com=require('../com/com.js');
const app = getApp();
Page({
  data: {
    userInfo: wx.getStorageSync('userInfo'),
    money: 0,
    cardId: 0,
    cardList: [],
    cardName: "请选择收款账号",
    PageTpye:1,
  },
  onLoad: function (options) {
    var PageThis = this;
    PageThis.setData({
      userInfo:wx.getStorageSync('userInfo'),
      PageTpye:options.tpye,
    })
    this.getCardList();
  },
  getCardList: function () {
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "get_bank_card",
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success: function (res) {
        res = res.data;
        if (res.state == 1) {
          var cardList = [];
          for (var i in res.data){
            cardList.push(res.data[i]['card_no'] + "-" + res.data[i]['card_bank'])
          }
          PageThis.setData({
            "cardList": cardList,
            "cardListValue": res.data
          })
        }
      }
    })
  },
  pickerChange:function(e){
    var PageThis = this;
    var id = e.detail.value;
    var cardList = PageThis.data.cardList;
    var cardListValue = PageThis.data.cardListValue;
    PageThis.setData({
      "cardName": cardList[id],
      "cardId": cardListValue[id]['card_id']
    })
  },
  inputChange: function (e) {
    var PageThis = this;
    PageThis.setData({
      "money": e.detail.value
    })
  },
  applySubmit:function(){
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "get_bank_card",
        money: Number(PageThis.data.money),
        card_id: PageThis.data.cardId,
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success:function(res){
        com.comUserInfo(PageThis.data.userInfo.manager_id);
        res = res.data;
        if(res.state == 1){
          wx.showToast({
            title: '申请成功',
            icon:"success",
            duration:1500
          })
          setTimeout(function(){
            wx.redirectTo({
              url: '../withdrawalsRecord/index',
            })
          },1500);
        }else{
          wx.showToast({
            title: res.msg,
            icon:"none",
            duration: 2000
          })
        }
      }
    })
  },
  wechatSubmit:function(){
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "apply_wx_withdraw",
        target: app.globalData.ThisWechatTarget,
        type: app.globalData.ThisWechatType,
        money: Number(PageThis.data.money),
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success:function(res){
        com.comUserInfo(PageThis.data.userInfo.manager_id);
        res = res.data;
        if(res.state == 1){
          wx.showToast({
            title: '申请成功',
            icon:"none",
            duration:1500
          })
          setTimeout(function(){
            wx.redirectTo({
              url: '../withdrawalsRecord/index',
            })
          },1500);
        }else{
          wx.showToast({
            title: res.msg,
            icon:"none",
            duration: 2000
          })
        }
      }
    })
  }
})