// pages/wxBindList/index.js
const app = getApp();
Page({
  data: {
    userInfo:{},
    userName:"",
    list:[]
  },
  onLoad: function (options) {
    this.setData({
      userInfo:wx.getStorageSync('userInfo'),
    });
  },
  onShow: function () {
    this.getList();
  },
  inputChange:function(e){
    var PageThis = this;
    PageThis.setData({
      "userName": e.detail.value
    })
  },
  getList(){
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "get_bind_manager",
        login_manager_id: PageThis.data.userInfo.manager_id,
        username:PageThis.data.userName,
      },
      success:function(res){
        var data = res.data.data;
        PageThis.setData({
          list:data
        })
      }
    })
  },
  unbind(e){
    var PageThis = this;
    var id = e.currentTarget.dataset.id;
    console.log(id);
    if(Number(id) > 0){
      wx.showModal({
        title: '温馨提示',
        content: "确认要解绑该用户？",
        success(res){
          if(res.confirm){
            wx.request({
              url: app.globalData.serverInfo.gateWayUrl,
              header: {
                'content-type': 'application/json'
              },
              method: 'POST',
              data: {
                "api_name":"unbind_manager_wx",
                "manager_id":id,
                "login_manager_id":PageThis.data.userInfo.manager_id
              },
              success(res){
                var ret = res.data;
                if(Number(ret.state) === 1){
                  wx.showToast({
                    title: ret.msg,
                  })
                  PageThis.getList();
                }else{
                  wx.showToast({
                    title: ret.msg,
                    icon: 'none'
                  })
                }
              }
            })
          }
        }
      })
    }
  }
})