import axiosInstance from '../https/useRequest'

type paramsobj = {
  page?: number
  page_size?: number
  keyword?: string
}
export type agentListResponse = {
  user_name: string
  last_login_time: string
  phone: string
  login_count: number
}

export type dataResponese = {
  list: agentListResponse[] | []
  page: number
  total_page: number
  total_count: number
}

export const AgentList = (params: paramsobj): Promise<dataResponese> => {
  return axiosInstance.post('/index/list', params)
}
