import React, { useState, useRef } from 'react'
import { InfiniteScroll, List, PullToRefresh, PageIndicator, Tag, SearchBar } from 'antd-mobile'
import { AgentList, agentListResponse, dataResponese } from '../../api/agent'
import { PullStatus } from 'antd-mobile/es/components/pull-to-refresh'
import { SearchBarRef } from 'antd-mobile/es/components/search-bar'

import './index.scss'

export function LoginList() {
  const [page, setPage] = useState(1)
  const [hasMore, setHasMore] = useState(true)
  const [data, setData] = useState<agentListResponse[]>([])
  const [resposeData, setResponseData] = useState<dataResponese>({
    total_page: 0,
    page: 0,
    list: [],
    total_count: 0,
  })

  const [searchValue, setSearchValue] = useState('')

  const searchRef = useRef<SearchBarRef>(null)

  async function loadMore() {
    const res: dataResponese = await AgentList({ page, page_size: 20, keyword: searchValue })
    setData((val) => [...val, ...res?.list])
    setHasMore(res?.list.length > 0)
    setResponseData(res)
    setPage((v) => ++v)
  }
  async function onRefresh() {
    const res = await AgentList({ page, page_size: 20, keyword: searchValue })
    setData([...res.list])
    setPage(1)
  }

  const statusRecord: Record<PullStatus, string> = {
    pulling: '用力拉',
    canRelease: '松开吧',
    refreshing: '玩命加载中...',
    complete: '好啦',
  }

  function checkCount(count: number): string {
    const countColor: [number, number, string][] = [
      [1, 3, 'primary'],
      [4, 10, 'warning'],
      [11, 99, 'danger'],
    ]
    function checkValue() {
      for (let i of countColor) {
        if (count > countColor[countColor.length - 1][1]) {
          return 'danger'
        }
        if (count >= i[0] && count <= i[1]) {
          return i[2]
        }
      }
      return ''
    }
    return checkValue()
  }

  return (
    <div className="anchor-dot">
      <div className="dot-postion">
        <PageIndicator
          total={resposeData!.total_page}
          current={resposeData!.page}
          direction="vertical"
          style={{
            '--dot-color': 'rgba(0, 0, 0, 0.4)',
            '--active-dot-color': '#ffc0cb',
            '--dot-size': '10px',
            '--active-dot-size': '30px',
            '--dot-border-radius': '50%',
            '--active-dot-border-radius': '15px',
            '--dot-spacing': '8px',
          }}
        />
      </div>
      <PullToRefresh
        onRefresh={onRefresh}
        renderText={(status) => {
          return <div>{statusRecord[status]}</div>
        }}
      >
        <div className="fixed-header">
          <div className="font-normal flex-space">
            <span>用户名</span>
            <span className="offset3">上次登录时间</span>
            <span className="offset4">登录手机号</span>
            <span className="offset2">登录次数</span>
          </div>
          <div
            style={{
              padding: '0 3%',
            }}
          >
            <SearchBar
              ref={searchRef}
              placeholder="请输入内容"
              showCancelButton
              onSearch={async (val) => {
                const res = await AgentList({ page: 1, page_size: 20, keyword: val })
                setData(res.list)
                setHasMore(res.list.length > 0)
                setSearchValue(val)
                // setPage(1)
              }}
            ></SearchBar>
          </div>
        </div>
        <div style={{ marginTop: '21%' }}>
          {data.map((item, index) => (
            <List.Item key={index}>
              <div className="flex-space">
                <span className="ceshi">{item.comment ? item.comment : item.user_name}</span>
                <span className="ceshi">{item.last_login_time}</span>
                <span className="ceshi">{item.phone}</span>
                <Tag color={checkCount(item.login_count)}>{item.login_count}</Tag>
              </div>
            </List.Item>
          ))}
        </div>
      </PullToRefresh>
      <InfiniteScroll loadMore={loadMore} hasMore={hasMore}></InfiniteScroll>
    </div>
  )
}
